﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Asteroid
  {
  class KeysPacket
    {
    private const sbyte KEY_HYPERSPACE = 0x01;
    private const sbyte KEY_FIRE = 0x02;
    private const sbyte KEY_THRUST = 0x04;
    private const sbyte KEY_RIGHT = 0x08;
    private const sbyte KEY_LEFT = 0x10;

    private byte[] m_Signature = { (byte)'c', (byte)'t', (byte)'m', (byte)'a', (byte)'m', (byte)'e', 0, 0};

    private sbyte m_Key = 0;//(sbyte)'@';

    private byte m_Ping = 0;
    /// <summary>
    /// Gets or sets the ping.
    /// </summary>
    /// <value>The ping.</value>
    /// ****************************************************************************************************
    /// * Datum: 16.04.2008 22:28
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte Ping
      {
      get
        {
        return m_Ping;
        }
      set
        {
        m_Ping = value;
        }
      }

    /// <summary>
    /// Gets the frame.
    /// </summary>
    /// <value>The frame.</value>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:41
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte[] Frame
      {
      get
        {
        m_Signature[6] = (byte)m_Key;
        m_Signature[7] = m_Ping;

        return m_Signature;
        }
      }
   
    /// <summary>
    /// Clears the keys.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:59
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void ClearKeys()
      {
      m_Key = 0;
      }

    /// <summary>
    /// Hyperspaces the specified b key pressed.
    /// </summary>
    /// <param name="bKeyPressed">if set to <c>true</c> [b key pressed].</param>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 23:09
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Hyperspace(bool bKeyPressed)
      {
      if (bKeyPressed)
        m_Key |= KEY_HYPERSPACE;
      else
        m_Key &= ~KEY_HYPERSPACE;
      }

    /// <summary>
    /// Fires the specified b key pressed.
    /// </summary>
    /// <param name="bKeyPressed">if set to <c>true</c> [b key pressed].</param>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 23:10
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Fire(bool bKeyPressed)
      {
      if (bKeyPressed)
        m_Key |= KEY_FIRE;
      else
        m_Key &= ~KEY_FIRE;
      }

    /// <summary>
    /// Thrusts the specified b key pressed.
    /// </summary>
    /// <param name="bKeyPressed">if set to <c>true</c> [b key pressed].</param>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 23:10
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Thrust(bool bKeyPressed)
      {
      if (bKeyPressed)
        m_Key |= KEY_THRUST;
      else
        m_Key &= ~KEY_THRUST;
      }

    /// <summary>
    /// Lefts the specified b key pressed.
    /// </summary>
    /// <param name="bKeyPressed">if set to <c>true</c> [b key pressed].</param>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 23:11
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Left(bool bKeyPressed)
      {
      if (bKeyPressed)
        {
        m_Key |= KEY_LEFT;
        m_Key &= ~KEY_RIGHT;
        }
      else
        m_Key &= ~KEY_LEFT;
      }

    /// <summary>
    /// Rights the specified b key pressed.
    /// </summary>
    /// <param name="bKeyPressed">if set to <c>true</c> [b key pressed].</param>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 23:11
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Right(bool bKeyPressed)
      {
      if (bKeyPressed)
        {
        m_Key |= KEY_RIGHT;
        m_Key &= ~KEY_LEFT;
        }
      else
        m_Key &= ~KEY_RIGHT;
      }
    }
  }
